#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
using namespace std;

double vremeZaSusret(pair<int, int>& prviTrkac, pair<int, int>& drugiTrkac) {
    if (prviTrkac.second <= drugiTrkac.second) return -1;
    return (double)(drugiTrkac.first - prviTrkac.first) / (prviTrkac.second - drugiTrkac.second);
}

struct Susret {
    double trenutak;
    int trkacA, trkacB;
    Susret(double t, int a, int b) : trenutak(t), trkacA(a), trkacB(b) {}
    bool operator<(const Susret& s) const {
        return trenutak > s.trenutak;
    }
};

int main() {
    int brojTrkaca;
    long long brojSusreta;
    cin >> brojTrkaca >> brojSusreta;

    vector<pair<int, int>> trkaci(brojTrkaca);
    for (int i = 0; i < brojTrkaca; ++i) {
        cin >> trkaci[i].first >> trkaci[i].second;
    }

    sort(trkaci.begin(), trkaci.end(), [](const pair<int, int>& a, const pair<int, int>& b) {
        return a.second > b.second;
    });

    priority_queue<Susret> planiraniSusreti;
    for (int i = 0; i < brojTrkaca; ++i) {
        for (int j = i + 1; j < brojTrkaca; ++j) {
            double vremeSusreta = vremeZaSusret(trkaci[i], trkaci[j]);
            if (vremeSusreta != -1) {
                planiraniSusreti.push(Susret(vremeSusreta, i, j));
            }
        }
    }

    double trenutakKSusreta = -1;
    for (int i = 0; i < brojSusreta && !planiraniSusreti.empty(); ++i) {
        trenutakKSusreta = planiraniSusreti.top().trenutak;
        planiraniSusreti.pop();
    }

    cout.precision(9);
    cout << fixed << trenutakKSusreta << endl;

    return 0;
}